
var qrFocus = false;

const initialArray = [
    [1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1],
    [1, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1],
    [1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1],
    [1, 0, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1],
    [1, 0, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1],
    [1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1],
    [1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1],
    [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 1, 1],
    [0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 1, 0, 1],
    [0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 0],
    [1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0],
    [0, 0, 1, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1],
    [0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 1],
    [1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 0, 1, 1, 0],
    [1, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0, 1, 1, 0, 1, 0, 0, 0, 1],
    [1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 1, 0, 1],
    [1, 0, 1, 1, 1, 0, 1, 0, 0, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 1, 1],
    [1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 0, 0, 1, 0, 1, 0, 0],
    [1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0],
    [1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1]
];

const expectedArray = [
    [1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1],
    [1, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1],
    [1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1],
    [1, 0, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1],
    [1, 0, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1],
    [1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1],
    [1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1],
    [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 1, 1],
    [0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 1, 0, 1],
    [0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 0],
    [1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0],
    [0, 0, 1, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1],
    [0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 1],
    [1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 0, 1, 1, 0],
    [1, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0, 1, 1, 0, 1, 0, 0, 0, 1],
    [1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 1, 0, 1],
    [1, 0, 1, 1, 1, 0, 1, 0, 0, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 1, 1],
    [1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 0, 0, 1, 0, 1, 0, 0],
    [1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0],
    [1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1]
];

document.addEventListener("DOMContentLoaded", (event) => {
    create_qr_matrix(document.getElementById("qr-container"), 21, 21);

    init_qr_matrix();
    document.addEventListener("keydown", handleKeyPress);
    document.getElementById("qr-answer").addEventListener("mouseenter", () => { qrFocus = true });
    document.getElementById("qr-answer").addEventListener("mouseleave", () => { qrFocus = false });

});

let qr_states = []

function annuler_qr() {
    prev = qr_states.pop();
    if (!(prev === undefined)) {
        register_qr_matrix_change(prev)
    }

    render_qr_matrix_from_storage()
}

function reset_qr() {
    qr_states.push(get_qr_matrix());
    register_qr_matrix_change(initialArray);
    render_qr_matrix_from_storage();
}

function create_qr_matrix(target, sizeX, sizeY) {
    target.classList.add("qr-matrix")
    for (let y = 0; y < sizeY; ++y) {
        for (let x = 0; x < sizeX; x++) {
            let cell = document.createElement("div");
            cell.dataset.x = x
            cell.dataset.y = y
            cell.id = "qr-cell-" + x.toString() + "-" + y.toString();
            cell.classList.add("qr-cell");
            cell.style.width = (100 / sizeX).toString() + "%";
            cell.addEventListener("click", () => {
                qr_matrix_cell_toggle(x, y);
            })
            target.appendChild(cell);
        }
    }
    selectCell(0, 0);
}

const QR_MATRIX_STORAGE_NAME = "qr_matrix"

function render_qr_matrix_from_storage() {
    const d = JSON.parse(localStorage.getItem(DATA_STORAGE_NAME));

    array = d[QR_MATRIX_STORAGE_NAME]

    for (let y = 0; y < 21; y++) {
        for (let x = 0; x < 21; x++) {
            let cell = document.getElementById("qr-cell-" + x + "-" + y);
            if (cell && array[y][x] === 1) {
                cell.classList.add("black");
            } else {
                cell.classList.remove("black");
            }
        }
    }
}

function init_qr_matrix() {

    const d = JSON.parse(localStorage.getItem(DATA_STORAGE_NAME));

    if (!d[QR_MATRIX_STORAGE_NAME]) {
        d[QR_MATRIX_STORAGE_NAME] = initialArray
        localStorage.setItem(DATA_STORAGE_NAME, JSON.stringify(d));
        register_qr_matrix_change(initialArray)
    }

    array = d[QR_MATRIX_STORAGE_NAME]

    render_qr_matrix_from_storage()
}

function qr_matrix_cell_toggle(x, y) {


    qr_states.push(get_qr_matrix());

    const cell = document.getElementById("qr-cell-" + x + "-" + y)
    cell.classList.toggle("black");


    register_qr_matrix_change(get_qr_matrix())

}

function register_qr_matrix_change(newArray) {
    const d = JSON.parse(localStorage.getItem(DATA_STORAGE_NAME));

    d[QR_MATRIX_STORAGE_NAME] = newArray

    localStorage.setItem(DATA_STORAGE_NAME, JSON.stringify(d))
}

function get_qr_matrix() {
    let matrix = [];

    for (let y = 0; y < 21; y++) {
        matrix.push([]);
        for (let x = 0; x < 21; x++) {
            let cell = document.getElementById("qr-cell-" + x + "-" + y)
            if (cell.classList.contains("black")) {
                matrix[y].push(1)
            } else {
                matrix[y].push(0)
            }
        }
    }
    return matrix;
}

function check_qr_matrix() {

    let matrix = get_qr_matrix();

    let erreurs = 0

    for (let y = 0; y < 21; y++) {
        for (let x = 0; x < 21; x++) {
            if (matrix[x][y] !== expectedArray[x][y]) {
                erreurs++;
            }
        }
    }
    return erreurs;
}

function selectCell(x, y) {
    const selected = document.querySelector(".selected");
    if (selected) {
        selected.classList.remove("selected");
    }

    const newSelected = document.getElementById("qr-cell-" + x + "-" + y);
    if (newSelected) {
        newSelected.classList.add("selected");
    }
}

function handleKeyPress(event) {
    if (qrFocus) {
        const selected = document.querySelector(".selected");
        if (!selected) return;

        let x = parseInt(selected.dataset.x);
        let y = parseInt(selected.dataset.y);



        switch (event.key) {
            case "ArrowUp":
                if (y > 0) selectCell(x, y - 1);
                break;
            case "ArrowDown":
                if (y < 20) selectCell(x, y + 1);
                break;
            case "ArrowLeft":
                if (x > 0) selectCell(x - 1, y);
                break;
            case "ArrowRight":
                if (x < 20) selectCell(x + 1, y);
                break;
            case " ":
                qr_matrix_cell_toggle(x, y);
                break;
        }

        event.preventDefault();
        event.stopPropagation();
    }

}

function togglegrid() {
    document.querySelector(".qr-matrix").classList.toggle("no-grid");
}




